<?php
// Koneksi ke database
$conn = pg_connect("host=localhost dbname=embee_acc user=postgres password=salman");

if (!$conn) {
    die("Koneksi database gagal!");
}

// Query untuk mendapatkan data
$query = "SELECT * FROM mb_kasbon ORDER BY tanggal_pengajuan DESC";
$result = pg_query($conn, $query);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Data Pengajuan Kasbon</title>
    <!-- Tambahkan link ke CSS dan JS DataTables -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>
</head>
<body>
    <h2 style="text-align: center; color: #4CAF50;">Data Pengajuan Kasbon</h2>

    <div style="max-width: 90%; margin: auto;">
        <table id="tabelKasbon" class="display" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>NIK</th>
                    <th>Nama</th>
                    <th>Jumlah</th>
                    <th>Tujuan</th>
                    <th>Rencana Pembayaran</th>
                    <th>Cara Pengembalian</th>
                    <th>No HP</th>
                    <th>Tanggal Pengajuan</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php
                while ($row = pg_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row['id']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nik']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nama']) . "</td>";
                    echo "<td>" . htmlspecialchars(number_format($row['jumlah'], 2)) . "</td>";
                    echo "<td>" . htmlspecialchars($row['tujuan']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['rencana_pembayaran']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['cara_pengembalian']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['no_hp']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['tanggal_pengajuan']) . "</td>";
                    echo "<td><a href='cetak_kasbon.php?id=" . htmlspecialchars($row['id']) . "' target='_blank'>Cetak</a></td>";
                    echo "</tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <script>
        $(document).ready(function() {
            $('#tabelKasbon').DataTable({
                "paging": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "language": {
                    "lengthMenu": "Tampilkan _MENU_ data per halaman",
                    "zeroRecords": "Tidak ada data yang ditemukan",
                    "info": "Menampilkan _START_ hingga _END_ dari _TOTAL_ data",
                    "infoEmpty": "Tidak ada data tersedia",
                    "search": "Cari:",
                    "paginate": {
                        "first": "Pertama",
                        "last": "Terakhir",
                        "next": "Berikutnya",
                        "previous": "Sebelumnya"
                    }
                }
            });
        });
    </script>
</body>
</html>
