<?php
require('fpdf/fpdf.php');

// Koneksi ke database
$conn = pg_connect("host=localhost dbname=embee_acc user=postgres password=salman");

if (!$conn) {
    die("Koneksi database gagal!");
}

// Ambil ID dari URL
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Query untuk mengambil data kasbon berdasarkan ID
$query = "SELECT * FROM mb_kasbon WHERE id = $id";
$result = pg_query($conn, $query);

if (pg_num_rows($result) == 0) {
    die("Data tidak ditemukan!");
}

$data = pg_fetch_assoc($result);

// Inisialisasi PDF
class PDF extends FPDF {
    // Header halaman
    function Header() {
        $this->SetFont('Arial', 'B', 14);
        $this->SetTextColor(50, 50, 50);
        $this->Cell(0, 10, 'Form Pengajuan Kasbon Karyawan', 0, 1, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, 'Koperasi Embee', 0, 1, 'C');
        $this->Ln(10); // Spasi setelah header
    }

    // Footer halaman
    function Footer() {
        $this->SetY(-15); // Posisi 1,5 cm dari bawah
        $this->SetFont('Arial', 'I', 8);
        $this->SetTextColor(128, 128, 128);
        $this->Cell(0, 10, 'Halaman ' . $this->PageNo(), 0, 0, 'C');
    }
}

// Buat instance PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 12);

// Styling
$pdf->SetFillColor(240, 240, 240); // Background abu-abu
$pdf->SetDrawColor(200, 200, 200); // Garis abu-abu

// Header data
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(50, 10, 'Informasi', 1, 0, 'C', true);
$pdf->Cell(140, 10, 'Data Pengajuan', 1, 1, 'C', true);

// Data baris pertama
$pdf->SetFont('Arial', '', 12);
// $pdf->Cell(50, 10, 'ID Kasbon', 1, 0, 'L', false);
// $pdf->Cell(140, 10, $data['id'], 1, 1, 'L', false);

$pdf->Cell(50, 10, 'NIK', 1, 0, 'L', false);
$pdf->Cell(140, 10, $data['nik'], 1, 1, 'L', false);

$pdf->Cell(50, 10, 'Nama', 1, 0, 'L', false);
$pdf->Cell(140, 10, $data['nama'], 1, 1, 'L', false);

$pdf->Cell(50, 10, 'Jumlah', 1, 0, 'L', false);
$pdf->Cell(140, 10, 'Rp ' . number_format($data['jumlah'], 2), 1, 1, 'L', false);

// MultiCell untuk Tujuan
$pdf->Cell(50, 10, 'Tujuan', 1, 0, 'L', false);
$pdf->MultiCell(140, 10, $data['tujuan'], 1, 'L', false);

// MultiCell untuk Rencana Pembayaran
$pdf->Cell(50, 10, 'Rencana Pembayaran', 1, 0, 'L', false);
$pdf->MultiCell(140, 10, $data['rencana_pembayaran'], 1, 'L', false);

$pdf->Cell(50, 10, 'Cara Pengembalian', 1, 0, 'L', false);
$pdf->Cell(140, 10, $data['cara_pengembalian'], 1, 1, 'L', false);

$pdf->Cell(50, 10, 'No HP', 1, 0, 'L', false);
$pdf->Cell(140, 10, $data['no_hp'], 1, 1, 'L', false);

$pdf->Cell(50, 10, 'Tanggal Pengajuan', 1, 0, 'L', false);
$pdf->Cell(140, 10, $data['tanggal_pengajuan'], 1, 1, 'L', false);

// Output PDF
$pdf->Output('I', 'Kasbon_' . $data['id'] . '.pdf');
?>
